<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<div class="modal" id="bfs-modal">

  <div class="modal-wrapper no-hpad" style="max-width: 1080px; max-width: min(1080px, 80vw);">
    <a href="#" class="modal-close">×</a>
    <div class="modal-content">

      <table>
        <tbody>
          <tr>

            <td>
              <div class="mm60">
                <img class="center block inline" style="height: 379px; transform: rotateY(180deg);" src="<?php echo $this->get_asset('images', 'kitty-cat.svg'); ?>" alt="kitty">
              </div>
            </td>
            <td>
              <div class="f20 lh30 mm" style="padding-left: 0;">
                <div class="f35 semibold mbl">
                  <?php _e("Wow, your site is", 'backup-backup'); ?> <span class="bold"><?php _e("FAT!", 'backup-backup'); ?></span>
                </div>

                <div class="mbl">
                  <?php printf(__("For large sites (above %sGB) we point you to the premium plugin, because:", 'backup-backup'), BMI_REV); ?>
                </div>

                <div class="mbl">
                  <ul>
                    <li class="hasArrowRight"><?php _e("Big sites tend to be more support heavy", 'backup-backup'); ?></li>
                    <li class="hasArrowRight"><?php _e("We also need to buy food", 'backup-backup'); ?></li>
                    <li class="hasArrowRight"><?php _e("The plugin offers many features for free which other plugins don’t", 'backup-backup'); ?></li>
                  </ul>
                </div>

                <div class="mbll">
                  <?php _e("We made it really affordable and it’s a great way to show your appreciation and support the further development of the plugin :) Thank you!", 'backup-backup'); ?>
                </div>

                <a href="<?php echo BMI_AUTHOR_URI; ?>" target="_blank" class="btn center lh45">
                  <div class="f18"><?php _e("Yes, that’s fair…", 'backup-backup'); ?></div>
                  <div class="f30 bold"><?php _e("Get premium", 'backup-backup'); ?></div>
                  <div class="f18"><?php _e("(which includes other cool features too!)", 'backup-backup'); ?></div>
                </a>

              </div>
            </td>

          </tr>
        </tbody>
      </table>

      <div class="center f18 mt">
        <span class="text-muted">
          <?php _e("Tip: You can also", 'backup-backup'); ?>
        </span>
        <span class="hoverable secondary">
          <a href="#" class="modal-closer secondary collapser-openner nodec" data-el="#exlucde-parts"><?php _e("exclude parts from backup", 'backup-backup'); ?></a>
        </span>
        <span class="text-muted">
          , <?php _e("which makes it smaller so that you stay below this limit.", 'backup-backup'); ?>
        </span>
      </div>

    </div>
  </div>

</div>
